/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderState;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.content.trains.track.TrackRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.Affine;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class StandardTrackBlockRenderer
implements TrackBlockRenderer {
    @Override
    public <Self extends Affine<Self>> void prepareTrackOverlay(Affine<Self> affine, class_1922 world, class_2338 pos, class_2680 state, BezierTrackPointLocation bezierPoint, class_2350.class_2352 direction, TrackTargetingBehaviour.RenderedTrackOverlayType type) {
        TrackBlockEntity trackTE;
        class_2586 length2;
        class_2586 class_25862;
        class_243 axis = null;
        class_243 diff = null;
        class_243 normal = null;
        if (bezierPoint != null && (class_25862 = world.method_8321(pos)) instanceof TrackBlockEntity) {
            TrackBlockEntity trackBE = (TrackBlockEntity)class_25862;
            BezierConnection bc = trackBE.getConnections().get(bezierPoint.curveTarget());
            if (bc != null) {
                double length2 = class_3532.method_15357((double)(bc.getLength() * 2.0));
                int seg = bezierPoint.segment() + 1;
                double t = (double)seg / length2;
                double tpre = (double)(seg - 1) / length2;
                double tpost = (double)(seg + 1) / length2;
                class_243 offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).method_1020(bc.getPosition(tpre)).method_1029();
                affine.translate(offset.method_1020(class_243.method_24955((class_2382)pos)));
                affine.translate(0.0f, -0.25f, 0.0f);
            } else {
                return;
            }
        }
        if (normal == null) {
            axis = ((TrackShape)((Object)state.method_11654(TrackBlock.SHAPE))).getAxes().get(0);
            diff = axis.method_1021((double)direction.method_10181()).method_1029();
            normal = ((TrackShape)((Object)state.method_11654(TrackBlock.SHAPE))).getNormal();
        }
        class_243 angles = TrackRenderer.getModelAngles(normal, diff);
        ((Affine)((Affine)((Affine)affine.center()).rotateY((float)angles.field_1351)).rotateX((float)angles.field_1352)).uncenter();
        if (axis != null) {
            affine.translate(0.0f, axis.field_1351 != 0.0 ? 0.4375f : 0.0f, axis.field_1351 != 0.0 ? (float)direction.method_10181() * 2.5f / 16.0f : 0.0f);
        } else {
            affine.translate(0.0f, 0.25f, 0.0f);
            if (direction == class_2350.class_2352.field_11060) {
                affine.rotateCentered((float)Math.PI, class_2350.field_11036);
            }
        }
        if (bezierPoint == null && (length2 = world.method_8321(pos)) instanceof TrackBlockEntity && (trackTE = (TrackBlockEntity)length2).isTilted()) {
            double yOffset = 0.0;
            for (BezierConnection bc : trackTE.getConnections().values()) {
                yOffset += ((class_243)bc.starts.getFirst()).field_1351 - (double)pos.method_10264();
            }
            ((Affine)((Affine)((Affine)affine.center()).rotateXDegrees((float)((double)(-direction.method_10181()) * trackTE.tilt.smoothingAngle.get()))).uncenter()).translate(0.0, yOffset / 2.0, 0.0);
        }
    }

    @Override
    public TrackBlockRenderState getRenderState(class_1937 world, class_243 offset, class_2680 trackState, class_2338 pos, class_2350.class_2352 direction, BezierTrackPointLocation bezier, TrackTargetingBehaviour.RenderedTrackOverlayType type, float scale) {
        TrackBlockEntity trackTE;
        class_2586 class_25862;
        class_2586 class_25863;
        if (world instanceof SchematicLevel && !(world instanceof PonderLevel)) {
            return null;
        }
        class_243 axis = null;
        class_243 diff = null;
        class_243 normal = null;
        if (bezier != null && (class_25863 = world.method_8321(pos)) instanceof TrackBlockEntity) {
            TrackBlockEntity trackBE = (TrackBlockEntity)class_25863;
            BezierConnection bc = trackBE.getConnections().get(bezier.curveTarget());
            if (bc != null) {
                double length = class_3532.method_15357((double)(bc.getLength() * 2.0));
                int seg = bezier.segment() + 1;
                double t = (double)seg / length;
                double tpre = (double)(seg - 1) / length;
                double tpost = (double)(seg + 1) / length;
                offset = bc.getPosition(t).method_1020(class_243.method_24955((class_2382)pos)).method_1019(offset).method_1031(0.0, -0.25, 0.0);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).method_1020(bc.getPosition(tpre)).method_1029();
            } else {
                return null;
            }
        }
        if (normal == null) {
            axis = ((TrackShape)((Object)trackState.method_11654(TrackBlock.SHAPE))).getAxes().getFirst();
            diff = axis.method_1021((double)direction.method_10181()).method_1029();
            normal = ((TrackShape)((Object)trackState.method_11654(TrackBlock.SHAPE))).getNormal();
        }
        StandardTrackBlockRenderState state = new StandardTrackBlockRenderState();
        state.offset = offset;
        class_243 angles = TrackRenderer.getModelAngles(normal, diff);
        state.yRot = (float)angles.field_1351;
        state.xRot = (float)angles.field_1352;
        if (axis != null) {
            state.offset2 = axis.field_1351 != 0.0 ? new class_243(0.0, 0.4375, (double)((float)direction.method_10181() * 2.5f / 16.0f)) : class_243.field_1353;
        } else if (direction == class_2350.class_2352.field_11060) {
            state.negative = true;
        }
        if (bezier == null && (class_25862 = world.method_8321(pos)) instanceof TrackBlockEntity && (trackTE = (TrackBlockEntity)class_25862).isTilted()) {
            double yOffset = 0.0;
            for (BezierConnection bc : trackTE.getConnections().values()) {
                yOffset += ((class_243)bc.starts.getFirst()).field_1351 - (double)pos.method_10264();
            }
            state.xRot2 = (float)Math.PI / 180 * (float)((double)(-direction.method_10181()) * trackTE.tilt.smoothingAngle.get());
            state.offset3 = Float.valueOf((float)(yOffset / 2.0));
        }
        state.layer = class_12249.method_75972();
        PartialModel partial = switch (type) {
            default -> throw new MatchException(null, null);
            case TrackTargetingBehaviour.RenderedTrackOverlayType.DUAL_SIGNAL -> AllPartialModels.TRACK_SIGNAL_DUAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER -> AllPartialModels.TRACK_OBSERVER_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL -> AllPartialModels.TRACK_SIGNAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.STATION -> AllPartialModels.TRACK_STATION_OVERLAY;
        };
        state.model = CachedBuffers.partial(partial, trackState);
        state.scale = scale;
        state.light = class_761.method_23794((class_1920)world, (class_2338)pos);
        return state;
    }

    @Override
    public TrackBlockRenderState getAssemblyRenderState(StationBlockEntity be, class_243 offset, class_1937 world, class_2338 pos, class_2680 blockState) {
        class_2350 direction = be.assemblyDirection;
        if (direction == null) {
            return null;
        }
        int length = be.assemblyLength;
        if (length == 0) {
            return null;
        }
        int[] locations = be.bogeyLocations;
        if (locations == null) {
            return null;
        }
        StandardTrackAssemblyRenderState state = new StandardTrackAssemblyRenderState();
        state.layer = class_12249.method_75972();
        state.offset = offset;
        state.angle = AngleHelper.rad(AngleHelper.horizontalAngle(direction));
        state.model = CachedBuffers.partial(AllPartialModels.TRACK_ASSEMBLING_OVERLAY, blockState);
        int colorWhenValid = 9876991;
        int colorWhenCarriage = 13303702;
        class_2338.class_2339 currentPos = pos.method_25503();
        int[][] nArrayArray = new int[length][];
        state.data = nArrayArray;
        int[][] data = nArrayArray;
        int index = 0;
        for (int location : locations) {
            if (location == -1 || location >= length) break;
            int i = index;
            index = location;
            while (i < index) {
                if (be.isValidBogeyOffset(i)) {
                    data[i] = new int[]{colorWhenValid, class_761.method_23794((class_1920)world, (class_2338)currentPos.method_10104(direction, 1))};
                }
                ++i;
            }
            data[i] = new int[]{colorWhenCarriage, class_761.method_23794((class_1920)world, (class_2338)currentPos.method_10104(direction, 1))};
            ++index;
        }
        while (index < length) {
            if (be.isValidBogeyOffset(index)) {
                data[index] = new int[]{colorWhenValid, class_761.method_23794((class_1920)world, (class_2338)currentPos.method_10104(direction, 1))};
            }
            ++index;
        }
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    public static class StandardTrackBlockRenderState
    extends TrackBlockRenderState {
        public class_243 offset;
        public float yRot;
        public float xRot;
        public class_243 offset2;
        public float xRot2;
        public Float offset3;
        public boolean negative;
        public SuperByteBuffer model;
        public int light;
        public float scale;

        @Override
        public void transform(class_4587 matrices) {
            matrices.method_61958(this.offset);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(this.xRot));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            if (this.offset2 != null) {
                if (this.offset2 != class_243.field_1353) {
                    matrices.method_61958(this.offset2);
                }
            } else {
                matrices.method_46416(0.0f, 0.25f, 0.0f);
                if (this.negative) {
                    matrices.method_49278((Quaternionfc)new Quaternionf().setAngleAxis(Math.PI, 0.0, 1.0, 0.0), 0.5f, 0.5f, 0.5f);
                }
            }
            if (this.offset3 != null) {
                matrices.method_46416(0.5f, 0.5f, 0.5f);
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(this.xRot2));
                matrices.method_46416(-0.5f, -0.5f, -0.5f);
                matrices.method_46416(0.0f, this.offset3.floatValue(), 0.0f);
            }
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.translate(0.5f, 0.0f, 0.5f)).scale(this.scale)).translate(-0.5f, 0.0f, -0.5f)).light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class StandardTrackAssemblyRenderState
    extends TrackBlockRenderState {
        public class_243 offset;
        public float angle;
        public SuperByteBuffer model;
        public int[][] data;

        @Override
        public void transform(class_4587 matrices) {
            matrices.method_61958(this.offset);
            matrices.method_49278((Quaternionfc)new Quaternionf().setAngleAxis(this.angle, 0.0f, 1.0f, 0.0f), 0.5f, 0.5f, 0.5f);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (int[] pair : this.data) {
                matricesEntry.method_67796(0.0f, 0.0f, 1.0f);
                if (pair == null) continue;
                this.model.color(pair[0]).light(pair[1]).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

